//
//  importPerfData.m
//  Gyronimo
//
//  Created by Claus Richter on 8/22/17.
//  Copyright © 2017 Claus Richter. All rights reserved.
//

#import "importPerfData.h"


@interface importPerfData ()

@end

@implementation importPerfData

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    
        
        

}




- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}




- (void) checkIfPerfDataIsLoaded {
    
    //NSLog( @"checkIfPerfDataIsLoaded  ");
    
    
    // ****************************************************************************************************************
    // ****************************************************************************************************************
    // ****************************************************************************************************************
    
    serverUrl  = [[NSUserDefaults standardUserDefaults]  stringForKey: @"serverUrl"];
    ACCategory = [[NSUserDefaults standardUserDefaults] objectForKey:@"ACCategory"];
    ACmanufacturer = [[NSUserDefaults standardUserDefaults] objectForKey:@"ACmanufacturer"];
    AC_Type = [[NSUserDefaults standardUserDefaults] objectForKey:@"AC_Type"];
    ACVariant = [[NSUserDefaults standardUserDefaults] objectForKey:@"ACVariant"];
    
    // ****************************************************************************************************************
    // ****************************************************************************************************************
    // ****************************************************************************************************************
    
    // check if data is already loaded
    
    arrayKey = [ [NSString alloc] initWithFormat:@"%@_%@_%@_%@_%@", ACCategory,ACmanufacturer, AC_Type, ACVariant, @"availableCharts" ];
    
    chartsArray = [[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy];
    
    
    
    //NSLog( @"chartsArray  %@", chartsArray);

    
    
     //[self importData];
   

    
    if (chartsArray.count >= 1) {
        
        //NSLog( @"data present for this aircraft! " );
        
        return;
        
        
    }else{
        
        
        //[self importData];
    }

    
    
    
    
}


- (void) loadDataFromDisk{
    
   chartImagesDictionary = [[NSMutableDictionary alloc] init];
   
    NSMutableArray *availableACTypesArray = [[NSMutableArray alloc] init];
    
    // for load from online:
    //NSString *inputCommunicationKey   = [[NSUserDefaults standardUserDefaults]  stringForKey:@"_inputCommunicationKey"];
    //NSString *availableACTypesURL = [ [NSString alloc] initWithFormat:@"%@%@%@", serverUrl, inputCommunicationKey, @"availableACTypes" ];
    
   
    NSString *availableACTypesURL = @"availableACTypes";
    
    NSString *path = [[NSBundle mainBundle] pathForResource:availableACTypesURL ofType:@"txt"];
    importedText = [NSString stringWithContentsOfFile:path encoding:NSUTF8StringEncoding error:nil];
    importedText  = [ importedText stringByReplacingOccurrencesOfString:@" " withString:@""];
    importedText  = [ importedText stringByReplacingOccurrencesOfString:@"\n" withString:@""];
    
    NSCharacterSet* charSet = [NSCharacterSet characterSetWithCharactersInString:@"|"];
    NSArray *components = [importedText componentsSeparatedByCharactersInSet:charSet];
    
    for(int i =0; i<components.count; i++) {
        NSArray* componentItems  = [[components objectAtIndex:i] componentsSeparatedByString:@","];
        if (componentItems.count > 1) {
            
            ACCategory = [componentItems objectAtIndex:0];
            ACmanufacturer = [componentItems objectAtIndex:1];
            AC_Type = [componentItems objectAtIndex:2];
            ACVariant = [componentItems objectAtIndex:3];
            
            //NSLog(@"loading .....");
            //NSLog(@"ACCategory %@", ACCategory);
            //NSLog(@"ACmanufacturer %@", ACmanufacturer);
            //NSLog(@"AC_Type %@", AC_Type);
            //NSLog(@"ACVariant %@", ACVariant);
            
            [availableACTypesArray addObject:AC_Type];
            
            [self loadDataFromDiskVoid];

        }
    }
    
  
    
    
}

- (void) loadDataFromDiskVoid {
    
    //NSLog( @"loadDataFromDiskVoid ...... " );
    // ****************************************************************************************************************
    //get available charts for this aircraft variant
    
    serverUrl = @"";
    availableChartsNameUrl = [ [NSString alloc] initWithFormat:@"%@%@_%@_%@_%@_availableCharts", serverUrl, ACCategory, ACmanufacturer, AC_Type, ACVariant];
    //NSLog( @"availableChartsNameUrl %@", availableChartsNameUrl);
    
    NSString *path = [[NSBundle mainBundle] pathForResource:availableChartsNameUrl ofType:@"txt"];
    //NSLog( @"path %@", path);
    
    importedText = [NSString stringWithContentsOfFile:path encoding:NSUTF8StringEncoding error:nil];
    //NSLog( @"importedText %@", importedText);
    //NSLog( @"substringToIndex %@", [importedText substringToIndex:1] );
    
    importedText  = [ importedText stringByReplacingOccurrencesOfString:@" " withString:@""];
    importedText  = [ importedText stringByReplacingOccurrencesOfString:@"\n" withString:@""];
    
    NSCharacterSet* charSet = [NSCharacterSet characterSetWithCharactersInString:@"|"];
    NSArray *components = [importedText componentsSeparatedByCharactersInSet:charSet];
    
    //NSLog( @"components %@", components);
    availableCharts = [[NSMutableArray alloc] init];
    // write only chart names in array availableCharts
    for(int i =0; i<components.count; i++) {
        NSArray* componentItems  = [[components objectAtIndex:i] componentsSeparatedByString:@","];
        //NSLog( @"componentItems %@", componentItems);
        if (componentItems.count > 1) {
            //NSLog( @"availableChart: %@", [componentItems objectAtIndex:0] );
            [availableCharts addObject: [componentItems objectAtIndex:0] ];
        }
    }
    
    //save array available Charts
    arrayKey = [ [NSString alloc] initWithFormat:@"%@_%@_%@_%@_%@", ACCategory, ACmanufacturer, AC_Type, ACVariant, @"availableCharts" ];
    [[NSUserDefaults standardUserDefaults]  setObject:availableCharts       forKey:arrayKey ];
    
    //NSLog( @"save array available Charts %@", availableCharts);
    //NSLog( @"for key %@", arrayKey);
    
    // ****************************************************************************************************************
    // *******************f*********************************************************************************************
    // ****************************************************************************************************************
    
    //save infoFilesGeneral for each chart
    infoFilesGeneral = [[NSMutableArray alloc] init];
    //NSLog(@"components.count %lu ", (unsigned long)components.count);
    
    
    for(int i =0; i<components.count; i++) {
        
        //NSLog(@"saving %d ", i);
        [infoFilesGeneral removeAllObjects];
        NSArray* componentItems  = [[components objectAtIndex:i] componentsSeparatedByString:@","];
        
        
        if (componentItems.count > 1) {
            for(int i2 =0; i2<componentItems.count; i2++) {
                [infoFilesGeneral addObject: [componentItems objectAtIndex:i2] ];
                chartNameForThisInfoFile = [infoFilesGeneral objectAtIndex:0];
                
                //NSLog( @"infoFilesGeneral: %@", [infoFilesGeneral objectAtIndex:0] );
                //NSLog( @"infoFilesGeneral.count %d" , infoFilesGeneral.count);
                
                
            }
            
           //NSLog( @"infoFilesGeneral: %@", infoFilesGeneral );            
            
        
           
            
           // import chart images
            
           NSString *imageDataUrl;
           imageDataUrl = [ [NSString alloc] initWithFormat:@"%@%@.png", serverUrl, chartNameForThisInfoFile  ];
            
           NSString *imageDataPath;
           imageDataPath = [ [NSString alloc] initWithFormat:@"%@%@", serverUrl, chartNameForThisInfoFile  ];
            
           NSString *path = [[NSBundle mainBundle] pathForResource:imageDataPath ofType:@"png"];
            
          
            //NSLog(@"imageDataUrld %@", imageDataUrl);
            //NSURL *imageURL = [NSURL URLWithString: imageDataUrl ];
            //NSData *imageData = [NSData dataWithContentsOfURL:imageURL];
            
            NSData *imageData = [NSData dataWithContentsOfFile:path];
            UIImage *image = [UIImage imageWithData:imageData];
            NSData *imageDataPNG = [NSData dataWithData:UIImagePNGRepresentation(image)];
            
            
            // save image
           if (image) {
                NSString *imageToSave = [NSString stringWithFormat:@"image_%@", chartNameForThisInfoFile ];
                //chartImagesDictionary[imageToSave] = imageDataPNG ;
               //NSLog(@"222saving chartimage -%@-", imageToSave);
               [imageDataPNG writeToFile:[imageToSave stringByAppendingPathComponent:@".png"] atomically:YES];
                NSArray   *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
                NSString  *documentsDirectory = [paths objectAtIndex:0];
                NSString  *filePath = [NSString stringWithFormat:@"%@/%@", documentsDirectory,imageToSave];
                [imageDataPNG writeToFile:filePath atomically:YES];

                
            }else{            
                NSLog(@"NO PERF IMAGE for -%@- ", chartNameForThisInfoFile);
            }

        }
        
        //NSLog( @"1");
        //NSLog( @"infoFilesGeneral: %@", infoFilesGeneral);
        //NSLog( @"chartNameForThisInfoFile: %@", chartNameForThisInfoFile);
        
        
        // save arrays
        if (chartNameForThisInfoFile.length > 1) {
            arrayKey = [ [NSString alloc] initWithFormat:@"%@_%@", chartNameForThisInfoFile, @"infoGeneral" ];
            //NSLog( @"saving infoFilesGeneral:  %@",  arrayKey);
            [[NSUserDefaults standardUserDefaults]  setObject:infoFilesGeneral       forKey:arrayKey ];
            
            // get number of compuation Parts
            int maxPartNumbers = [[infoFilesGeneral objectAtIndex:2] intValue];
            //NSLog(@"maxPartNumbers = %d", maxPartNumbers);
            
            // for each part, save info, curves, datasetX, datasetY
            
            
            for(int partNumber =0; partNumber<maxPartNumbers; partNumber++) {
                
                availableChartsNameUrl = [ [NSString alloc] initWithFormat:@"%@%@_part%d", serverUrl, chartNameForThisInfoFile, partNumber+1  ];
                //NSLog( @"availableChartsNameUrl %@", availableChartsNameUrl);
                
                // read comp data from text files
                // i.e. Heli_Leonardo_AW169_sup4_SC4_12_part1 1.txt
                
                
               
                //NSString *availableChartsFileOriginal = [NSString stringWithContentsOfURL:availableChartsUrl usedEncoding:&encoding error:&error];
                
                NSString *path = [[NSBundle mainBundle] pathForResource:availableChartsNameUrl ofType:@"txt"];
                
                NSString *availableChartsFileOriginal = [NSString stringWithContentsOfFile:path encoding:NSUTF8StringEncoding error:nil];
                
                availableChartsFileOriginal  = [ availableChartsFileOriginal stringByReplacingOccurrencesOfString:@" " withString:@""];
                //NSLog(@"availableChartsFileOriginal %@", availableChartsFileOriginal);
                
                //NSLog( @"2");
                
                // info array
                NSCharacterSet* charSet = [NSCharacterSet characterSetWithCharactersInString:@"|"];
                NSArray* components = [availableChartsFileOriginal componentsSeparatedByCharactersInSet:charSet];
                infoArray = [[components objectAtIndex:0] componentsSeparatedByString:@","];
                //NSLog(@"infoArray %@", infoArray);
                arrayKey = [ [NSString alloc] initWithFormat:@"%@_part%d_%@", chartNameForThisInfoFile, partNumber+1, @"infoFile" ];
                //NSLog( @"saving infoArray: %@", arrayKey);
                [[NSUserDefaults standardUserDefaults]  setObject:infoArray       forKey:arrayKey ];
                
                
                // curves array
                curvesArray = [[components objectAtIndex:1] componentsSeparatedByString:@","];
                arrayKey = [ [NSString alloc] initWithFormat:@"%@_part%d_%@",  chartNameForThisInfoFile, partNumber+1, @"curves" ];
                //NSLog( @"saving curvesArray: %@", curvesArray);
                [[NSUserDefaults standardUserDefaults]  setObject:curvesArray       forKey:arrayKey ];
                
                
                
                
                // save array for each dataset x and y
                
                axisDataArray = [[NSArray alloc] init];
                //NSLog( @"curvesArray %@ %@ ", chartNameForThisInfoFile, curvesArray );
                
                //NSLog( @"3");
                
                int curvesCounter = 0;
                int doubler = 0;
                
                for(int c =2; c<curvesArray.count*2+2; c++) {
                    
                    //NSLog( @"c %d", c);
                    
                    if (c% 2) {
                        //odd is Y
                        
                        axisDataArray  = [[components objectAtIndex:c] componentsSeparatedByString:@","];
                        //NSLog( @"odd y infoArray chartname %@ curve %@ array%@", chartNameForThisInfoFile, [curvesArray objectAtIndex:curvesCounter],  axisDataArray );
                        arrayKey = [ [NSString alloc] initWithFormat:@"%@_part%d_%@_%@",  chartNameForThisInfoFile, partNumber+1, [curvesArray objectAtIndex:curvesCounter], @"yAxis" ];
                        [[NSUserDefaults standardUserDefaults]  setObject:axisDataArray       forKey:arrayKey ];
                        //NSLog( @"saving key %@", arrayKey );
                        
                    }else{
                        //even is X
                        
                        axisDataArray  = [[components objectAtIndex:c] componentsSeparatedByString:@","];
                        //NSLog( @"even x infoArray %@ %@ %@", chartNameForThisInfoFile, [curvesArray objectAtIndex:curvesCounter], axisDataArray);
                        arrayKey = [ [NSString alloc] initWithFormat:@"%@_part%d_%@_%@",  chartNameForThisInfoFile, partNumber+1, [curvesArray objectAtIndex:curvesCounter], @"xAxis" ];
                        [[NSUserDefaults standardUserDefaults]  setObject:axisDataArray       forKey:arrayKey ];
                        //NSLog( @"saving key %@", arrayKey );
                        
                        if ([[curvesArray objectAtIndex:curvesCounter] isEqualToString: @"0"] ) {
                            //NSLog( @" 0  axisDataArray %@", axisDataArray );
                        }
                        
                    }
                    
                    doubler = doubler + 1; if ( doubler == 2 ) { curvesCounter = curvesCounter + 1;doubler = 0;}
                    
                }
            }
        }
    }
    
    
    [[NSUserDefaults standardUserDefaults]  setObject: chartImagesDictionary  forKey:@"chartImagesDictionary"];
    
    
    
    // test import data
    
    //arrayKey = [ [NSString alloc] initWithFormat:@"%@_%@_%@_%@_%@_%@_%@_%@", @"Heli", @"Leonardo", @"AW169", @"", @"sec4_4_13", @"part1" , @"0" , @"yAxis"];
    //NSLog(@"test Leonardo_AW169__sec4_4_13_part1_0_yAxis = %.3f", [[[[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy] objectAtIndex:0] floatValue]   );
    
    //NSLog(@"array  %@", [[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy] );
    
    
    /*
     arrayKey = [ [NSString alloc] initWithFormat:@"%@_%@_%@_%@_%@_%@_%@_%@", @"Heli", @"Leonardo", @"AW169", @"NONE", @"sup4_SC4_12", @"part1" , @"-10" , @"xAxis"];
     //NSLog(@"test must be 611.007  = %@", [[[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy] objectAtIndex:4]    );
     if ([[[[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy] objectAtIndex:4] isEqualToString:@"611.007"] ) {
     //NSLog(@"import test OK!");
     }else{
     //NSLog(@"import error!***************************************");
     }
     */
    
    
    
    
    
    
    
    
}

- (void) importData {
        
    serverUrl  = [[NSUserDefaults standardUserDefaults]  stringForKey: @"serverUrl"];
    
    ACCategory = [[NSUserDefaults standardUserDefaults] objectForKey:@"ACCategory"];
    ACmanufacturer = [[NSUserDefaults standardUserDefaults] objectForKey:@"ACmanufacturer"];
    AC_Type = [[NSUserDefaults standardUserDefaults] objectForKey:@"AC_Type"];
    ACVariant = [[NSUserDefaults standardUserDefaults] objectForKey:@"ACVariant"];
    
    
    
    
    
    // ****************************************************************************************************************
    // ****************************************************************************************************************
    // ****************************************************************************************************************
    
    //get available charts for this aircraft variant
    availableChartsNameUrl = [ [NSString alloc] initWithFormat:@"%@%@_%@_%@_%@_availableCharts%@", serverUrl, ACCategory, ACmanufacturer, AC_Type, ACVariant, @".txt" ];
    //NSLog( @"availableChartsNameUrl %@", availableChartsNameUrl);
    
    
    
    NSURL *URL = [NSURL URLWithString: availableChartsNameUrl];
    
    [[NSURLCache sharedURLCache] removeAllCachedResponses];
    [[NSURLCache sharedURLCache] setDiskCapacity:0];
    [[NSURLCache sharedURLCache] setMemoryCapacity:0];
    
    
       
    NSStringEncoding encoding;
    NSError *error;

    importedText = [NSString stringWithContentsOfURL:URL usedEncoding:&encoding error:&error];
    
    // fake it!
    //importedText = @"Heli_Airbus_H125_NONE_sup28_fig2_5_4_IGE,HIGE,1 part,";
    
    //NSLog( @"importedText %@", importedText);
    
    importedText  = [ importedText stringByReplacingOccurrencesOfString:@" " withString:@""];
    importedText  = [ importedText stringByReplacingOccurrencesOfString:@"\n" withString:@""];
    
    NSCharacterSet* charSet = [NSCharacterSet characterSetWithCharactersInString:@"|"];
    NSArray *components = [importedText componentsSeparatedByCharactersInSet:charSet];
    //NSLog( @"components %@", components);
    availableCharts = [[NSMutableArray alloc] init];
    // write only chart names in array availableCharts
    for(int i =0; i<components.count; i++) {
        NSArray* componentItems  = [[components objectAtIndex:i] componentsSeparatedByString:@","];
        if (componentItems.count > 1) {
            //NSLog( @"availableChart: %@", [componentItems objectAtIndex:0] );
            [availableCharts addObject: [componentItems objectAtIndex:0] ];
        }
    }
    
    //save array available Charts
    arrayKey = [ [NSString alloc] initWithFormat:@"%@_%@_%@_%@_%@", ACCategory, ACmanufacturer, AC_Type, ACVariant, @"availableCharts" ];
    [[NSUserDefaults standardUserDefaults]  setObject:availableCharts       forKey:arrayKey ];
    
    //availableCharts
    //sup4_SC4_12
    //sec4_4_15
    //sec4_4_13
    
    
    // ****************************************************************************************************************
    // ****************************************************************************************************************
    // ****************************************************************************************************************
    
    //save infoFilesGeneral for each chart
    infoFilesGeneral = [[NSMutableArray alloc] init];
    
    
 
    
    for(int i =0; i<components.count; i++) {
        
        
        //NSLog(@"saving %d ", i);
        
        [infoFilesGeneral removeAllObjects];
        NSArray* componentItems  = [[components objectAtIndex:i] componentsSeparatedByString:@","];
        if (componentItems.count > 1) {
            for(int i2 =0; i2<componentItems.count; i2++) {
                [infoFilesGeneral addObject: [componentItems objectAtIndex:i2] ];
                chartNameForThisInfoFile = [infoFilesGeneral objectAtIndex:0];
                
                //NSLog( @"chartNameForThisInfoFile: %@", chartNameForThisInfoFile );
                //NSLog( @"info file general componentItems: %@", componentItems );
                // this goes into the info file
                /*
                 "Heli_Leonardo_AW169__sup4_SC4_12",
                 firstChart,
                 2parts,
                 width1200,
                 height1800
                 */
                

            }
            
            //NSLog( @"infoFilesGeneral: %@", infoFilesGeneral );
            
            // import chart images
          
            NSString *imageDataUrl;
            imageDataUrl = [ [NSString alloc] initWithFormat:@"%@%@.png", serverUrl, chartNameForThisInfoFile  ];
            //NSLog(@"imageDataUrld %@", imageDataUrl);
            NSURL *imageURL = [NSURL URLWithString: imageDataUrl ];
            NSData *imageData = [NSData dataWithContentsOfURL:imageURL];
            UIImage *image = [UIImage imageWithData:imageData];
            NSData *imageDataPNG = [NSData dataWithData:UIImagePNGRepresentation(image)];
            
            // save image
            if (image) {
                
                NSString *imageToSave = [NSString stringWithFormat:@"image_%@", chartNameForThisInfoFile ];
                chartImagesDictionary[imageToSave] = imageDataPNG ;
                //NSLog(@"saving imageToSave -%@-", imageToSave);
                
                
            }else{
                //NSLog(@"importData NO IMAGE FOUND ON SERVER");
                
            }

            
        }
        
        //NSLog( @"infoFilesGeneral: %@", infoFilesGeneral);
        
        
        // save arrays
        if (chartNameForThisInfoFile.length > 1) {
            arrayKey = [ [NSString alloc] initWithFormat:@"%@_%@", chartNameForThisInfoFile, @"infoGeneral" ];
            //NSLog( @"saving infoFilesGeneral:  %@",  arrayKey);
            [[NSUserDefaults standardUserDefaults]  setObject:infoFilesGeneral       forKey:arrayKey ];
            
            // get number of compuation Parts
            int maxPartNumbers = [[infoFilesGeneral objectAtIndex:2] intValue];
            //NSLog(@"maxPartNumbers = %d", maxPartNumbers);
            
            // for each part, save info, curves, datasetX, datasetY
            
            
            for(int partNumber =0; partNumber<maxPartNumbers; partNumber++) {
                
                availableChartsNameUrl = [ [NSString alloc] initWithFormat:@"%@%@_part%d%@", serverUrl, chartNameForThisInfoFile, partNumber+1, @".txt"  ];
                //NSLog( @"availableChartsNameUrl %@", availableChartsNameUrl);
                
                // read comp data from text files
                // i.e. Heli_Leonardo_AW169_sup4_SC4_12_part1 1.txt
                
                
                NSURL *availableChartsUrl = [NSURL URLWithString: availableChartsNameUrl];
                NSStringEncoding encoding;
                NSError *error;
                NSString *availableChartsFileOriginal = [NSString stringWithContentsOfURL:availableChartsUrl usedEncoding:&encoding error:&error];
                availableChartsFileOriginal  = [ availableChartsFileOriginal stringByReplacingOccurrencesOfString:@" " withString:@""];
                //NSLog(@"availableComputationsTextFile %@", availableChartsFileOriginal);
                
                
                // info array
                NSCharacterSet* charSet = [NSCharacterSet characterSetWithCharactersInString:@"|"];
                NSArray* components = [availableChartsFileOriginal componentsSeparatedByCharactersInSet:charSet];
                infoArray = [[components objectAtIndex:0] componentsSeparatedByString:@","];
                //NSLog(@"infoArray %@", infoArray);
                arrayKey = [ [NSString alloc] initWithFormat:@"%@_part%d_%@", chartNameForThisInfoFile, partNumber+1, @"infoFile" ];
                //NSLog( @"saving infoArray: %@", arrayKey);
                [[NSUserDefaults standardUserDefaults]  setObject:infoArray       forKey:arrayKey ];
                
                
                // curves array
                curvesArray = [[components objectAtIndex:1] componentsSeparatedByString:@","];
                arrayKey = [ [NSString alloc] initWithFormat:@"%@_part%d_%@",  chartNameForThisInfoFile, partNumber+1, @"curves" ];
                //NSLog( @"saving curvesArray: %@", curvesArray);
                [[NSUserDefaults standardUserDefaults]  setObject:curvesArray       forKey:arrayKey ];
                
                
                
                
                // save array for each dataset x and y
                
                axisDataArray = [[NSArray alloc] init];
                //NSLog( @"curvesArray %@ %@ ", chartNameForThisInfoFile, curvesArray );
                
                
                
                int curvesCounter = 0;
                int doubler = 0;
                
                for(int c =2; c<curvesArray.count*2+2; c++) {
                    
                    //NSLog( @"c %d", c);
                    
                    if (c% 2) {
                        //odd is Y
                        
                        axisDataArray  = [[components objectAtIndex:c] componentsSeparatedByString:@","];
                        //NSLog( @"odd y infoArray chartname %@ curve %@ array%@", chartNameForThisInfoFile, [curvesArray objectAtIndex:curvesCounter],  axisDataArray );
                        arrayKey = [ [NSString alloc] initWithFormat:@"%@_part%d_%@_%@",  chartNameForThisInfoFile, partNumber+1, [curvesArray objectAtIndex:curvesCounter], @"yAxis" ];
                        [[NSUserDefaults standardUserDefaults]  setObject:axisDataArray       forKey:arrayKey ];
                        //NSLog( @"saving key %@", arrayKey );
                        
                    }else{
                        //even is X
                        
                        axisDataArray  = [[components objectAtIndex:c] componentsSeparatedByString:@","];
                        //NSLog( @"even x infoArray %@ %@ %@", chartNameForThisInfoFile, [curvesArray objectAtIndex:curvesCounter], axisDataArray);
                        arrayKey = [ [NSString alloc] initWithFormat:@"%@_part%d_%@_%@",  chartNameForThisInfoFile, partNumber+1, [curvesArray objectAtIndex:curvesCounter], @"xAxis" ];
                        [[NSUserDefaults standardUserDefaults]  setObject:axisDataArray       forKey:arrayKey ];
                        //NSLog( @"saving key %@", arrayKey );
                        
                        if ([[curvesArray objectAtIndex:curvesCounter] isEqualToString: @"0"] ) {
                            //NSLog( @" 0  axisDataArray %@", axisDataArray );
                        }
                        
                    }
                    
                    doubler = doubler + 1; if ( doubler == 2 ) { curvesCounter = curvesCounter + 1;doubler = 0;}
                    
                }
            }
        }
    }
    
    
     [[NSUserDefaults standardUserDefaults]  setObject: chartImagesDictionary  forKey:@"chartImagesDictionary"];
    
    // test import data
    
    //arrayKey = [ [NSString alloc] initWithFormat:@"%@_%@_%@_%@_%@_%@_%@_%@", @"Heli", @"Leonardo", @"AW169", @"", @"sec4_4_13", @"part1" , @"0" , @"yAxis"];
    //NSLog(@"test Leonardo_AW169__sec4_4_13_part1_0_yAxis = %.3f", [[[[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy] objectAtIndex:0] floatValue]   );
    
    //NSLog(@"array  %@", [[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy] );
    
    
    /*
    arrayKey = [ [NSString alloc] initWithFormat:@"%@_%@_%@_%@_%@_%@_%@_%@", @"Heli", @"Leonardo", @"AW169", @"NONE", @"sup4_SC4_12", @"part1" , @"-10" , @"xAxis"];
    //NSLog(@"test must be 611.007  = %@", [[[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy] objectAtIndex:4]    );
    if ([[[[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy] objectAtIndex:4] isEqualToString:@"611.007"] ) {
        //NSLog(@"import test OK!");
    }else{
        //NSLog(@"import error!***************************************");
    }
     */
    
    
    
    
    
    
    
    
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
